import sql from 'mssql';
import { config } from './config.js';

const findAuthorById = async (id) => {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Execute the query
    const result = await pool
      .request()
      .input('id', sql.Int, id)
      .query(`SELECT * FROM Authors WHERE AuthorID = @id`);

    // return the result
    return result.recordset.length > 0 ? result.recordset[0] : null;
  } catch (err) {
    console.error(err);
  }
};

async function findAuthorsByLastName(term) {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Execute a query
    const result = await pool
      .request()
      .input('term', sql.VarChar, `%${term}%`)
      .query(`SELECT * FROM Authors WHERE LastName LIKE @term`);

    return result.recordset;
  } catch (err) {
    console.error('Error finding authors by last name:', err);
  }
}

async function findAuthors(limit = 5, offset = 0) {
  try {
    // Connect to the database
    const pool = await sql.connect(config);

    // Execute a query
    const result = await pool
      .request()
      .input('offset', sql.Int, offset)
      .input('limit', sql.Int, limit)
      .query(
        `SELECT * FROM Authors 
         ORDER BY FirstName
         OFFSET @offset ROWS 
         FETCH FIRST @limit ROWS ONLY`
      );

    return result.recordset;
  } catch (err) {
    console.error('Error finding authors:', err);
  }
}
export { findAuthorById, findAuthorsByLastName, findAuthors };
